/*
 * Decompiled with CFR 0.152.
 */
package com.wistrand.midlet.valentine;

import com.wistrand.midlet.fp.FP;
import com.wistrand.midlet.sprite.Sprite;
import com.wistrand.midlet.sprite.SpriteHandler;
import com.wistrand.midlet.valentine.Main;
import com.wistrand.midlet.valentine.Util;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class BalloonSprite
extends Sprite {
    String txt;
    SpriteHandler handler;
    int darkCol;
    static Font font = Font.getFont((int)64, (int)0, (int)8);

    public BalloonSprite(SpriteHandler spriteHandler, String string, int n, int n2) {
        this.txt = string;
        this.handler = spriteHandler;
        this.moveTo(n, n2);
        if (Main.theMain.canvas.bgColor == 0xFFFFFF) {
            this.setColor(0);
        } else {
            this.setColor(0xFFFFFF);
        }
    }

    public void setColor(int n) {
        super.setColor(n);
        this.darkCol = n == 0 ? -1 : Util.interpolateRGB(0, n, 128);
    }

    public void setText(String string) {
        this.txt = string;
    }

    public void update() {
        this.setSpeed(FP.rnd(-512, 512), FP.rnd(-1024, 128));
        super.update();
        int n = this.txt.length() * 3 << 8;
        int n2 = Main.theMain.canvas.getWidth() << 8;
        if (this.x < n) {
            this.x = n;
        }
        if (this.x > n2 - n) {
            this.x = n2 - n;
        }
        if (this.y <= 0) {
            this.handler.remove(this);
        }
    }

    public void paint(Graphics graphics) {
        int n = this.x / 256;
        int n2 = this.y / 256;
        graphics.setFont(font);
        int n3 = 0;
        int n4 = 0;
        while (-1 != (n3 = this.txt.indexOf("\n", n4))) {
            this.draw(graphics, this.txt, n4, n3, n, n2);
            n4 = n3 + 1;
            n2 += font.getHeight();
        }
        this.draw(graphics, this.txt, n4, this.txt.length(), n, n2);
    }

    void draw(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        if (Main.theMain.detailLevel > 0 && this.darkCol != -1) {
            graphics.setColor(this.darkCol);
            graphics.drawSubstring(string, n, n2 - n, n3 - 1, n4 - 1, 17);
        }
        graphics.setColor(this.col);
        graphics.drawSubstring(string, n, n2 - n, n3, n4, 17);
    }

    public String toString() {
        return "BalloonSprite[id=" + this.id + ", txt=" + this.txt + "]";
    }
}

